import { world, system, EquipmentSlot, CommandPermissionLevel, CustomCommandParamType, CustomCommandStatus, Player, ItemStack } from "@minecraft/server";

const d = [];
const h = new Map();
const s = [EquipmentSlot.Head, EquipmentSlot.Chest, EquipmentSlot.Legs, EquipmentSlot.Feet, EquipmentSlot.Offhand];

system.beforeEvents.startup.subscribe(({ customCommandRegistry: r }) => {
  r.registerEnum("nxzott:activeHosts", []);
  
  r.registerCommand({
    name: "nxzott:create",
    description: "Become a host to share inventory with other players",
    permissionLevel: CommandPermissionLevel.Any,
    cheatsRequired: false
  }, (o) => {
    const p = o.initiator ?? o.sourceEntity;
    if (!(p instanceof Player)) return { status: CustomCommandStatus.Failure, message: "§cOnly players can use this command." };
    system.run(() => create(p));
  });

  r.registerCommand({
    name: "nxzott:join",
    description: "Join a host to share inventory",
    permissionLevel: CommandPermissionLevel.Any,
    cheatsRequired: false,
    mandatoryParameters: [{ name: "hostName", type: CustomCommandParamType.String }]
  }, (o, n) => {
    const p = o.initiator ?? o.sourceEntity;
    if (!(p instanceof Player)) return { status: CustomCommandStatus.Failure, message: "§cOnly players can use this command." };
    system.run(() => join(p, n));
  });

  r.registerCommand({
    name: "nxzott:leave",
    description: "Leave your current host",
    permissionLevel: CommandPermissionLevel.Any,
    cheatsRequired: false
  }, (o) => {
    const p = o.initiator ?? o.sourceEntity;
    if (!(p instanceof Player)) return { status: CustomCommandStatus.Failure, message: "§cOnly players can use this command." };
    system.run(() => leave(p));
  });

  r.registerCommand({
    name: "nxzott:close",
    description: "Close your host and stop sharing inventory",
    permissionLevel: CommandPermissionLevel.Any,
    cheatsRequired: false
  }, (o) => {
    const p = o.initiator ?? o.sourceEntity;
    if (!(p instanceof Player)) return { status: CustomCommandStatus.Failure, message: "§cOnly players can use this command." };
    system.run(() => close(p));
  });
});

system.runInterval(() => {
  if (world.getAllPlayers().length > 1) sync();
}, 1);

world.afterEvents.entityDie.subscribe(e => {
  if (e.deadEntity.typeId !== "minecraft:player") return;
  const n = e.deadEntity.name;
  if (!h.has(n)) return;
  
  for (const p of world.getAllPlayers()) p.runCommand("clear");
  
  const m = h.get(n);
  for (const mn of m) {
    if (mn === n) continue;
    const mp = world.getAllPlayers().find(x => x.name === mn);
    if (mp) {
      restore(mp);
      mp.sendMessage("§7[§e!§7]§r Host died. Your inventory has been restored.");
    }
    const i = d.findIndex(x => x.n === mn);
    if (i !== -1) d.splice(i, 1);
  }
  
  const hi = d.findIndex(x => x.n === n);
  if (hi !== -1) d.splice(hi, 1);
  h.delete(n);
});

function create(p) {
  const n = p.name;
  if (h.has(n)) {
    p.sendMessage("§7[§c!§7]§r You are already a host!");
    return;
  }
  for (const [hn, m] of h) {
    if (m.has(n)) {
      p.sendMessage(`§7[§c!§7]§r You are already synced with host '${hn}'. Leave first!`);
      return;
    }
  }
  h.set(n, new Set([n]));
  const inv = p.getComponent("inventory")?.container;
  const eq = p.getComponent("equippable");
  if (inv && eq) d.push({ n, i: getInv(inv), e: getEq(eq), h: n });
  p.sendMessage("§7[§a!§7]§r Host created successfully! Other players can now join you.");
}

function join(p, hn) {
  const n = p.name;
  if (!h.has(hn)) {
    p.sendMessage(`§7[§c!§7]§r Host '${hn}' not found!`);
    const a = Array.from(h.keys()).join(", ");
    if (a) p.sendMessage(`§7[§e!§7]§r Available hosts: ${a}`);
    return;
  }
  for (const [ho, m] of h) {
    if (m.has(n)) {
      p.sendMessage(`§7[§c!§7]§r You are already in a host. Use /nxzott:leave first!`);
      return;
    }
  }
  const inv = p.getComponent("inventory")?.container;
  const eq = p.getComponent("equippable");
  if (inv && eq) {
    backup(p, inv, eq);
    p.sendMessage("§7[§e!§7]§r Your inventory has been backed up.");
  }
  h.get(hn).add(n);
  const hp = world.getAllPlayers().find(x => x.name === hn);
  if (hp) {
    const hi = hp.getComponent("inventory")?.container;
    const he = hp.getComponent("equippable");
    if (hi && he && inv && eq) {
      for (let i = 0; i < 36; i++) inv.setItem(i, hi.getItem(i));
      for (const sl of s) eq.setEquipment(sl, he.getEquipment(sl));
      d.push({ n, i: getInv(inv), e: getEq(eq), h: hn });
    }
  }
  p.sendMessage(`§7[§a!§7]§r Successfully joined host '${hn}'!`);
  hp?.sendMessage(`§7[§a!§7]§r ${n} has joined your host.`);
}

function leave(p) {
  const n = p.name;
  let fh = null;
  for (const [hn, m] of h) {
    if (m.has(n) && hn !== n) {
      fh = hn;
      m.delete(n);
      break;
    }
  }
  if (!fh) {
    p.sendMessage("§7[§c!§7]§r You are not in any host!");
    return;
  }
  const i = d.findIndex(x => x.n === n);
  if (i !== -1) d.splice(i, 1);
  restore(p);
  p.sendMessage(`§7[§a!§7]§r You left host '${fh}'.`);
  const hp = world.getAllPlayers().find(x => x.name === fh);
  hp?.sendMessage(`§7[§e!§7]§r ${n} has left your host.`);
}

function close(p) {
  const n = p.name;
  if (!h.has(n)) {
    p.sendMessage("§7[§c!§7]§r You are not a host!");
    return;
  }
  const m = h.get(n);
  for (const mn of m) {
    if (mn === n) continue;
    const mp = world.getAllPlayers().find(x => x.name === mn);
    if (mp) {
      restore(mp);
      mp.sendMessage(`§7[§e!§7]§r Host '${n}' has closed. Your inventory has been restored.`);
    }
    const i = d.findIndex(x => x.n === mn);
    if (i !== -1) d.splice(i, 1);
  }
  const hi = d.findIndex(x => x.n === n);
  if (hi !== -1) d.splice(hi, 1);
  h.delete(n);
  p.sendMessage("§7[§a!§7]§r Host closed successfully.");
}

function backup(p, inv, eq) {
  const b = { inventory: [], equipment: [] };
  for (let i = 0; i < 36; i++) {
    const it = inv.getItem(i);
    if (it) b.inventory.push({
      slot: i,
      id: it.typeId,
      amount: it.amount,
      durability: it.getComponent("durability")?.damage || 0,
      nameTag: it.nameTag,
      lore: it.getLore()
    });
  }
  for (const sl of s) {
    const it = eq.getEquipment(sl);
    if (it) b.equipment.push({
      slot: sl,
      id: it.typeId,
      amount: it.amount,
      durability: it.getComponent("durability")?.damage || 0,
      nameTag: it.nameTag,
      lore: it.getLore()
    });
  }
  try {
    world.setDynamicProperty(`nxzott:backup:${p.name}`, JSON.stringify(b));
  } catch (e) {
    p.sendMessage("§7[§c!§7]§r Failed to backup inventory: " + e);
  }
}

function restore(p) {
  const inv = p.getComponent("inventory")?.container;
  const eq = p.getComponent("equippable");
  if (!inv || !eq) return;
  try {
    const bd = world.getDynamicProperty(`nxzott:backup:${p.name}`);
    if (!bd) {
      p.sendMessage("§7[§e!§7]§r No backup found. Your inventory has been cleared.");
      for (let i = 0; i < 36; i++) inv.setItem(i, undefined);
      for (const sl of s) eq.setEquipment(sl, undefined);
      return;
    }
    const b = JSON.parse(bd);
    for (let i = 0; i < 36; i++) inv.setItem(i, undefined);
    for (const sl of s) eq.setEquipment(sl, undefined);
    for (const it of b.inventory) {
      const item = new ItemStack(it.id, it.amount);
      if (it.durability > 0) {
        const dur = item.getComponent("durability");
        if (dur) dur.damage = it.durability;
      }
      if (it.nameTag) item.nameTag = it.nameTag;
      if (it.lore && it.lore.length > 0) item.setLore(it.lore);
      inv.setItem(it.slot, item);
    }
    for (const it of b.equipment) {
      const item = new ItemStack(it.id, it.amount);
      if (it.durability > 0) {
        const dur = item.getComponent("durability");
        if (dur) dur.damage = it.durability;
      }
      if (it.nameTag) item.nameTag = it.nameTag;
      if (it.lore && it.lore.length > 0) item.setLore(it.lore);
      eq.setEquipment(it.slot, item);
    }
    world.setDynamicProperty(`nxzott:backup:${p.name}`, undefined);
    p.sendMessage("§7[§a!§7]§r Your inventory has been restored from backup.");
  } catch (e) {
    p.sendMessage("§7[§c!§7]§r Failed to restore inventory: " + e);
  }
}

function sync() {
  for (const p of world.getAllPlayers()) {
    const inv = p.getComponent("inventory")?.container;
    const eq = p.getComponent("equippable");
    const sv = d.find(x => x.n === p.name);
    if (sv) {
      const ci = getInv(inv);
      const ce = getEq(eq);
      if (!same(sv.i, ci) || !same(sv.e, ce)) {
        const ph = sv.h;
        const hm = h.get(ph);
        if (hm) {
          for (const mn of hm) {
            if (mn === p.name) continue;
            const mp = world.getAllPlayers().find(x => x.name === mn);
            if (!mp) continue;
            const mi = mp.getComponent("inventory")?.container;
            const me = mp.getComponent("equippable");
            if (mi && me) {
              for (let i = 0; i < 36; i++) mi.setItem(i, inv.getItem(i));
              for (const sl of s) me.setEquipment(sl, eq.getEquipment(sl));
            }
          }
        }
        d.forEach(v => {
          if (v.h === ph) {
            v.i = ci;
            v.e = ce;
          }
        });
      }
    }
  }
}

function same(a, b) {
  if (a.length !== b.length) return false;
  for (let i = 0; i < a.length; i++) if (JSON.stringify(a[i]) !== JSON.stringify(b[i])) return false;
  return true;
}

function getInv(c) {
  const a = [];
  for (let i = 0; i < 36; i++) {
    const it = c.getItem(i);
    if (it) a.push({ id: it.typeId, n: it.amount, d: it.getComponent("durability")?.damage || 0, s: i });
  }
  return a;
}

function getEq(c) {
  return s.map(sl => {
    const it = c.getEquipment(sl);
    return { id: it ? it.typeId : "", d: it?.getComponent("durability")?.damage || 0, s: sl };
  });
}