<div align="center">
  <h1><img src="https://raw.githubusercontent.com/faizul726/faizul726.github.io/refs/heads/main/matject-misc/logo.png" height="54px"></img>Matject v3.7.0 [EOL]</h1>
  <p>A smart, highly customizable material.bin replacer for Mincraft Windows.<br>Supports both Minecraft and Minecraft Preview with backup and restore.</p>
  <code>Last updated: August 09, 2025</code>
</div>

<br>

## Current state of Matject
As you may have seen, Matject is receiving way less updates now.  
It's because Matject has peak of its' development thus it requires less maintenance now.  
I have decided to abandon Matject because Microsoft as a company is not predictable. In recent Windows update they started silently rejecting PowerShell admin requests and I can't reproduce the issue myself. There will be a lot more issues like this in future and I won't be able to catch up all time.

**So, Matject is provided as-is now. I will not be providing any updates for it anymore.  
material-updater may stop working because it uses hardcoded values.**

Thank you for all the support so far. I greatly appreciate everyone who was involved in the project. The repository will be archived now.

![404](./modules/404.jpg)
[Shader credit: Sharkitty](https://faizul726.github.io/sharkitty-shader)

---

**[💡 How to use?](#-quick-guide)** | **[🔄 How to remove shaders](#-how-to-restore-to-default--uninstall-shaders) | [💁‍♂️ I need help](#need-help)**

---

<div align="center">
  <h3>❌ DO NOT MIRROR/REUPLOAD THIS ANYWHERE! ❌</h3>
  <b>Matject is now distributed under a license from YSS Group.<br>By using Matject, you agree to the terms stated in <a href=./TERMS.md>TERMS.md</a></b>
</div>

---

![hero](https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/matject_1.png)


# 🛠️ Requirements
- [IObit Unlocker](https://www.iobit.com/en/iobit-unlocker.php) installed (mandatory, no need to do anything with it afterwards)
- PowerShell (mandatory) (pre installed on most Windows systems by default)
- Ability to read
- Common sense  
`Sorry for being rude, I am tired of spoonfeeding clueless people.`

</br>

# 📗 Here's what you need to know
- Only RenderDragon shaders for Windows/Merged are supported.

- You don't have to open Matject everytime for shaders. It's only needed when you want to apply/swap/remove shaders.  
  Once shader is applied **it will stay** until you update the game or use shader removal in Matject.

- Check out Matject Settings to fine tune it to your needs.  

- Matject doesn't patch Minecraft it dynamically replaces .material.bin files of Minecraft.  

- Matject needs Minecraft to have unmodified materials so backup and shader removal works properly. If you are not sure whether you have original materials or not, use `verifyMaterials_vX.XX.XX.bat` from https://mcpebd.github.io/materials for your Minecraft version.  

- If you use Microsoft Defender antivirus then make sure to go to Device security -> Core isolation 
  and turn off "Microsoft Vulnerable Driver Blocklist" and "Local Security Authority protection" to make sure IObit Unlocker doesn't fail silently,
  you may need to disable "Memory integrity" as well.

</br>

<details><summary><b>💡 More things you need to know (click to expand)</b></summary>
	<hr>
	<ul>
  <li>If you switch/remove shaders often then it's recommended to use matjectNEXT instead of Auto with these settings:
    <ul>
  <li><strong>General</strong>
    <ul>
      <li>Default method: matjectNEXT</li>
      <li>Use material-updater to update materials: ON</li>
      <li>Disable confirmations: ON</li>
    </ul>
  </li>
  <li><strong>Custom paths</strong>
    <ul>
      <li>Set custom Minecraft app path (optional)</li>
      <li>Set custom Minecraft data path (optional but recommended)</li>
    </ul>
  </li>
  <li><strong>matjectNEXT settings</strong>
    <ul>
      <li>Just sync and exit: ON</li>
      <li>Automatically open Minecraft after sync: ON</li>
    </ul>
  </li>
  <li><strong>Updates & Debug</strong>
    <ul>
      <li>Run IObit Unlocker as admin: ON</li>
      or
      <li>Always run Matject as admin: ON</li>
      or
      <li>Just manually run Matject as admin</li>
    </ul>
  </li>
</ul>
  </li>
  <li>If you have installed Minecraft using Bedrock Launcher or some kind of version switcher or have write access to Minecraft app folder then it's recommended to enable Direct Write mode. So, Matject uses tradtional copy/delete commands instead of IObit Unlocker.</li>
    <li>If blocks become invisible after injecting, enable material-updater from Matject Settings or use the version which is compatible with your Minecraft version.</li>
    <li>Matject can't enable Deferred Rendering/Vibrant Visuals/RTX.</li>
		<li>The word "Injection" here means file replacement. So Matject basically uses IObit Unlocker to dynamically replace files.</li>
    <li>Matject needs unmodified materials (game files) to begin with. Or the shader removal function will be useless.</li>
    <li>Some packs have subpacks which is like settings for resource packs. You can see a gear icon in some activated resource packs</li>
		<li>Matject doesn't patch your game. So just removing shader from resource pack won't work. Use Shader Removal of Matject for that.</li>
		<li>Always try to use latest version. Matject has a built in updater to update itself.</li>
		<li>Matject is universal. It will continue to work fine as long as Mojang doesn't heavily changes how shaders work.</li>
		<li>Avoid downloading Matject from random links except <a href=https://github.com/faizul726/matject>github.com/faizul726/matject</a></li>
	</ul>
	<hr>
</details>

<details><summary><b>⭐ Full feature list (click to expand)</b></summary>
	<hr>
	<ul>
		<li><b>Easy to use:</b> No Command Prompt/Terminal knowledge is required.</li>
    <li><b>Highly customizable:</b> Adjustments according to your needs can be made in Matject Settings.</li>
		<li><b>Fully offline:</b> Can be used offline. Internet is optionally used to enhance experience.</li>
		<li><b>Portable:</b> All necessary files are stored in the same folder as Matject.</li>
		<li><b>Fast as jet</b>: Takes less than 60 seconds to apply a shader. </li>
		<li><b>Preview support</b>: Also supports Minecraft Preview backups and settings are stored separately for Preview and Release.  </li>
		<li><b>Automatic backups:</b> Backups are made automatically when game is updated.</li>
		<li><b>Restore game files:</b> You can go back to original whenever you want. </li>
		<li><b>Automatic processing:</b> MCPACK/ZIPs are automatically processed.</li>
		<li><b>Auto shader updater:</b> Shaders can be updated using <a href=https://github.com/mcbegamerxx954/material-updater>material-updater</a> (also fixes invisible blocks).</li>
		<li><b>Auto updater:</b> Can automatically update itself if you want.</li>
		<li><b>Smart file replacement:</b> Keeps track of modified files and automatically restores when needed.</li>
		<li><b>matjectNEXT:</b> Applies shaders based on the first activated pack in Global Resource Packs.</li>
    <li><b>Direct write mode:</b> If Minecraft folder is writable, you can enable this option so Matject will use traditional copy/delete commands instead of IObit Unlocker. (you still need to have IObit Unlocker installed because this feature is still not fully tested)</li>
	</ul>
	<hr>
</details>

<details><summary><b>⚠️ Known issues (click to expand)</b></summary>
	<hr>
	<ul>
		<li>Doesn't work well with long folder path and too many shader files.</li>
		<li>Some antivirus may prevent IObit Unlocker from working. (AVG and Norton are known to do this)</li>
		<li>Some shaders may cause the game to crash or show red sky. It's not a fault of Matject.</li>
	</ul>
	<hr>
</details>
<br>
<details><summary><b>🖼️ Screenshots (click to expand)</b></summary>
	<!-- Main Image -->
<img src="https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/matject_1.png" alt="matject_1">

<!-- Table with Images and Captions -->
<table>
  <tr>
    <td style="text-align: center;">
      <img src="https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/matject_2.png" style="width: 100%;" alt="Matject Settings"><br>
      <b>Matject Settings</b>
    </td>
    <td style="text-align: center;">
      <img src="https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/matject_3.png" style="width: 100%;" alt="Custom paths"><br>
      <b>Custom paths</b>
    </td>
  </tr>
  <tr>
    <td style="text-align: center;">
      <img src="https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/matject_4.png" style="width: 100%;" alt="matjectNEXT"><br>
      <b>matjectNEXT</b>
    </td>
    <td style="text-align: center;">
      <img src="https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/matject_5.png" style="width: 100%;" alt="Restore materials"><br>
      <b>Shader removal</b>
    </td>
  </tr>
</table>

<img src="https://github.com/user-attachments/assets/740da8aa-0177-482a-a065-4f4f48ac857f" style="width: 100%;">
<p align=center><i>You can also call it Matjet because it's as fast as a jet.<br><code>I know I'm exaggerating...</code></i></p>
</details>

<br>

## ✨ What's new in v3.7.0?
* matjectNEXT is now stable
* Added new matjectNEXT settings
* More user friendly messages
* [See full changelog...](#-changelog)

</br><br>


# 💡 Quick Guide

1. Install [IObit Unlocker](https://www.iobit.com/en/iobit-unlocker.php)  
   No need to do anything with it afterwards.

</br>

![screenshot](https://github.com/user-attachments/assets/4422464e-26a3-4068-993e-adc76817ca9c)

2. Download code as ZIP.  

3. Extract the ZIP file.
4. Open `matject`/`matject.bat` (with gear icon).

<br>

![screenshot](https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/file_list.png)

5. **Follow on screen instructions** (Please READ. It says what to do in each step.)

<br>

> [!TIP]
> ### Need help?  
> Join any server below and mention me.  
> **[Bedrock Graphics](https://faizul726.github.io/bedrockgraphics-discord)** `In channel #matject`  
> Or  
> [Newb Discord server](https://faizul726.github.io/newb-discord) `In channel #newb-support or #renderdragon`  
> [YSS Discord Server](https://faizul726.github.io/yss-discord) `In channel #windows or #renderdragon`  
> 
> And, I will try to help you. I don't own any Discord server. These are other communities where I am active most.

</br>

<br><br>

## 🔄 How to restore to default / uninstall shaders?
> [!TIP]  
> Original files are restored automatically when the game is updated.

1. Open Matject.
2. Go to **[R] Shader removal/Tools**.
3. Go to **[1] Shader Removal / Restore default materials**
4. Select **[1] Dynamic Restore** or **[2] Full Restore** (both are same, except full restore takes a bit more time).

<br>

![screenshot](https://raw.githubusercontent.com/faizul726/faizul726.github.io/main/matject/screenshots/shader_removal.png)



</br>
</br>

## 🤝 Credits
* **[IObit Unlocker](https://www.iobit.com/en/iobit-unlocker.php)** (backbone of Matject)
* **[@mcbegamerxx954](https://github.com/mcbegamerxx954/)** (for [material-updater](https://github.com/mcbegamerxx954/material-updater) and speed improvements)
* **[jq](https://jqlang.github.io/jq)** (used to process JSON files for matjectNEXT)
* **[@jcau8](https://github.com/jcau8)** (critical bug fixes)
* **[@Veka0](https://github.com/Veka0)** (material compatibility checker)


**Honorable Mentions**  
People of [YSS](https://faizul726.github.io/yss-discord) and [Newb Community](https://faizul726.github.io/newb-discord) for their humble support.  

[TrngN0786](https://x.com/TrngN0786) and [@Theffyxz](https://github.com/Theffyxz) for helping me to fix bugs.  
[@Sharkitty](https://github.com/Sharkitty), [@FlaredRoverCodes](https://github.com/FlaredRoverCodes), [@BatmanBinSuparman49](https://github.com/BatmanBinSuparman49) and all other people who tested and gave feedback.

</br>

</br>

## 🤔 FAQ
**Q. Is it safe?**  
A. Yes, it is. You're welcome to review the code.

**Q. What is matjectNEXT?**  
A. matjectNEXT is an advanced version of Matject that replaces materials based on the pack the user has set in Global Resource Packs, with help of **[jq](https://jqlang.github.io/jq)**.  
Inspired by [Draco](https://github.com/mcbegamerxx954/draco-injector) which is made by [@mcbegamerxx954](https://github.com/mcbegamerxx954/).

**Q. How is this different from [BetterRenderDragon](https://github.com/ddf8196/BetterRenderDragon/)?**  
A. BetterRenderDragon uses *memory injection*, all the changes are made in memory and those don't persist. You have to open BRD each time to use shaders.  
*It's not universal, so BRD devs have to update it for newer Minecraft versions to make it work.*  
Changes made by Matject will stay until Minecraft is updated or user restores default materials from Matject.  
It's mostly universal, so it should work with any Minecraft version.

**Q. Does it require internet to work?**  
A. No, internet is optionally used to enhance user experience
* To check for updates and show the changelog. Updating is optional.
* To show Matject announcements
* To get [jq](https://jqlang.github.io/jq) by itself (for matjectNEXT).  
* To get [material-updater](https://github.com/mcbegamerxx954/material-updater) by itself.  

**Q. I have questions/need help.**  
A. Ask in one of the Discord servers [above](#need-help)


**Q. What folders does it access?**  
<details closed>
<summary>A. It accesses the following folders: </summary>

> ###### READ only:
> - `%ProgramFiles(x86)%\IObit\IObit Unlocker\IObitUnlocker` (backbone of Matject)
> - Minecraft app location. *Which is obtained using this PowerShell command:*
> ```powershell
> (Get-AppxPackage -Name Microsoft.Minecraft*).InstallLocation
> ```
> - `%LOCALAPPDATA%\Packages\Microsoft.Minecraft*_8wekyb3d8bbwe\LocalState\games\com.mojang\minecraftpe\global_resource_packs.json` (for matjectNEXT)
> - `%LOCALAPPDATA%\Packages\Microsoft.Minecraft*_8wekyb3d8bbwe\LocalState\games\com.mojang\resource_packs\*` (for matjectNEXT)
> - `.settings` `Backups\*` `Backups (Preview)\*` `logs` `MATERIALS` `MCPACKS` `modules\*` `tmp`
> - `Custom paths: Minecraft app, data, IObit Unlocker`
>
> ###### READ and WRITE:
> - `%ProgramFiles%\WindowsApps` (to unlock WindowsApps)
> - `%ProgramFiles%\WindowsApps\Microsoft.Minecraft*_*_*__8wekyb3d8bbwe\data\renderer\materials`
> - `%LOCALAPPDATA%\Packages\Microsoft.Minecraft*_8wekyb3d8bbwe\LocalState\games\com.mojang\minecraftpe\global_resource_packs.json` (to reset global packs)
> - `.settings` `Backups\*` `Backups (Preview)\*` `logs` `MATERIALS` `modules` `tmp`
> - `Custom paths: Minecraft app, data`

</details>
</br>

**Q. মুরগি কি ধান খায়?** 🐓  
A. হ, খায়।

</br><br>


## Support
You can support me through various ways:  
* Sharing Matject to others
* Giving a star to Matject (scroll above)
* Giving feedback and suggestion through [Bedrock Graphics Discord server](https://faizul726.github.io/bedrockgraphics-discord) or reporting bugs through [GitHub Issues](https://github.com/faizul726/matject/issues)
* [Donating](https://faizul726.github.io/matject/docs/donate)

<br><br>

## 🕓 Changelog
<!--TEMPLATE

<details open><summary><b>v3.7.patch - month day, 2025</b></summary>
<ul>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
  <li>placeholder</li>
</ul>
</br>
</details>

2 lines gap between each -->


<details open><summary><b>v3.7.0 - August 09, 2025</b></summary>
<ul>
  <li>Added Matject Exam</li>
  <li>Added separate help pages for some places</li>
  <li>Added new guiding texts in some places to make it more user friendly</li>
  <li>Added target pack number setting for matjectNEXT</li>
  <li>Added setting to automatically open Minecraft after matjectNEXT sync</li>
  <li>Added setting to reapply the same pack for matjectNEXT</li>
  <li>Added setting to scan only development or normal resource packs</li>
  <li>Added progress bar for Full restore step 3</li>
  <li>Added progress bar for Materials backup</li>
  <li>Added Never Gonna Give You Up</li>
  <li>Matject is now distributed under a license from YSS Group.</li>
  <li>Matject Settings now stores most settings in single text file</li>
  <li>matjectNEXT is no longer BETA</li>
  <li>Full restore now shows an error if Full Restore didn't go well</li>
  <li>Incomplete backup/injection is now handled separately for both editions of Minecraft</li>
  <li>Direct write mode now uses COPY and DEL instead of MOVE</li>
  <li>Improved Custom Minecraft app path setting</li>
  <li>Improved resource pack scanning for matjectNEXT</li>
  <li>Improved custom path inputs</li>
  <li>Improved Matject startup logic</li>
  <li>Moved a lot of extra information under debug mode</li>
  <li>More robust file/folder creation in some cases</li>
  <li>Fixed 'terminal to use' prompt of initial shortcut creation</li>
  <li>Fixed an issue with dynamic restore when run IObit Unlocker as admin is on</li>
  <li>Deprecated Auto and Manual method</li>
</ul>
</br>
</details>


<details><summary><b>v3.6.0 - Apr 16, 2025</b></summary>
<ul>
  <li>Added auto version detection for material-updater [preview not supported]</li>
  <li>Added direct write mode: Use normal move/delete commands instead of IObit Unlocker [sideloaded installation only]</li>
  <li>Added new settings UI for material-updater</li>
  <li>Added a brand new loading screen</li>
  <li>Added a setting to change the number of materials processed per cycle for full restore</li>
  <li>Added a secret game</li>
  <li>Reworked full restore logic: It should work better now</li>
  <li>Full restore no longer empties backup folder</li>
  <li>A warning now will be shown if materials are ntot moved/deleted properly</li>
  <li>MATERIALS folder now has to be empty before using auto/manual</li>
  <li>Custom path toggle color will be orange if path is invalid</li>
  <li>matjectNEXT now supports IObit Unlocker popup reduction</li>
  <li>Updated about screen</li>
  <li>Fixed non-English text display issues in some places</li>
  <li>Fixed an issue with GameData location</li>
  <li>Lots of small UI improvements</li>
</ul>
</br>
</details>


<details><summary><b>v3.5.2 - Feb 21, 2025</b></summary>
<ul>
  <li>Fixed WindowsApps unlock failure</li>
  <li>Fixed Minecraft Preview backup handling</li>
  <li>Auto closing for IObit Unlocker no longer shows a separate window</li>
  <li>Shortcuts can now open Matject in Windows Terminal</li>
  <li>Added notification sound in some confirmation screens</li>
  <li>Added a setting to force using PowerShell for extracting ZIPs</li>
  <li>Added 10 new Matject tips</li>
  <li>Added MIT license</li>
  <li>Improved Matject opening behavior</li>
  <li>Improved admin permission detection</li>
  <li>Improved shortcut creation/deletion</li>
  <li>Minor UI improvements</li> 
</ul>
</br>
</details>


<details><summary><b>v3.5.1 - Feb 02, 2025</b></summary>
<ul>
  <li>Fixed a CRITICAL BUG that deletes all user files.</li>
  <li>Added module verification to ensure reliability.</li>
  <li>Matject no longer runs when tried to run without extracting.</li>
  <li>Matject now uses more "specific" locations.</li>
  <li>Fixed an issue with Matject updater.</li>
  <li>Fixed an issue with full restore.</li>
  <li>Other minor changes.</li>
</ul>
</br>
</details>


<details><summary><b>v3.5.0 - Jan 15, 2025</b></summary>
<ul>
  <li>Added Matject updater.</li>
  <li>Added multiple MCPACK/ZIP support for MCPACKS folder.</li>
  <li>Added Matject tips.</li>
  <li>Added "Show announcements" setting.</li>
  <li>Added "Disable tips" setting.</li>
  <li>Added "Run Matject as admin always" setting.</li>
  <li>Added "Run IObit Unlocker as admin" setting to reduce admin permission requests.</li>
  <li>Added manifest checker for matjectNEXT.</li>
  <li>Added more bugs to fix later.</li>
  <li>Auto mode now shows last MCPACK and subpack name.</li>
  <li>Restore screen now shows restore date.</li>
  <li>ZIPs now can also be opened as MCPACK.</li>
  <li>IObit Unlocker messages are now automatically closed when Matject is run as admin.</li>
  <li>Getting Minecraft details is now faster.</li>
  <li>First run now asks to download material-updater.</li>
  <li>curl should no longer be able to execute using variables.</li>
  <li>Fixed a math related issue with update checker.</li>
  <li>Fixed a issue with how MCPACKs are processed <code>Thanks to raden</code></li>
  <li>Cursor is now hidden where it's not needed.</li>
  <li>Some UI improvements.</li>
</ul>
</br>
</details>


<details><summary><b>v3.4.0 - Dec 23, 2024</b></summary>
<ul>
  <li>Added subpack support for auto method.</li>
  <li>Added zipped materials support for auto method.</li>
  <li>Added new settings: Don't open folder automatically.</li>
  <li>Added loading text (not everywhere)</li>
  <li>Added reset settings option.</li>
  <li>Added Drop to shell (needs debug mode)</li>
  <li>Can now make shortcuts.</li>
  <li>New icon if using shortcut.</li>
  <li>Optimized folder opening.</li>
  <li>Optimized update checker.</li>
  <li>Should no longer cause crashes when folder name contains space.</li>
  <li>Should no longer fully exit if something goes wrong.</li>
  <li>Preview mode now is automatically disabled when not installed.</li>
  <li>Other minor changes.</li>
</ul>
</br>
</details>


<details><summary><b>v3.3.0 - Dec 10, 2024</b></summary>
<ul>
  <li>Added Minecraft Preview support.</li>
  <li>matjectNEXT now can be used without DEBUG MODE.</li>
  <li>Improved matjectNEXT functionality.</li>
  <li>Improved extract speed by using <code>tar</code>.</li>
  <li>Improved settings functionality.</li>
  <li>Improved backup ZIP check.</li>
  <li>Fixed Dynamic Restore comparison.</li>
  <li>Fixed OLDVERSION variable.</li>
  <li>Delete Backups folder if empty.</li>
  <li>Other minor changes.</li>
</ul>
</br>
</details>

<details><summary><b>v3.2.2 - Dec 06, 2024</b></summary>
<ul>
  <li>Added custom Minecraft launcher support (thanks to <a href=https://x.com/TrngN0786>@TrngN0786</a>)</li>
  <li>Added custom Minecraft data path support</li>
  <li>Added custom IObit Unlocker path support</li>
  <li>Added interruption check</li>
  <li>Added restore confirmation</li>
  <li>Added an easter egg</li>
  <li>Update checker now shows the changelog</li>
  <li>Fixed colors in some texts</li>
  <li>Fixed RESTORELIST variable (thanks to <a href=https://x.com/TrngN0786>@TrngN0786</a>)</li>
  <li>Fixed Minecraft app path and Just sync and exit toggle</li>
  <li>Other minor bug fixes</li>
</ul>
</br>
</details>

<details><summary><b>v3.2.1 - Dec 04, 2024</b></summary>
<ul>
  <li>Fixed matjectNEXT unable to find pack path (once again thanks to <a href=https://github.com/jcau8>@jcau8</a>)</li>
  <li>Added compatibility check for materials (thanks to <a href=https://github.com/Veka0>@Veka0</a>)</li>
  <li>Revamped settings page with tabs</li>
  <li>Several small improvements to functionality</li>
  <li>Added development_resource_packs support (matjectNEXT)</li>
  <li>Improved MCPACK detection</li>
  <li>Added the ability to replace backup using ZIP file (Restore & Others)</li>
</ul>
</br>
</details>

<details><summary><b>v3.2.0 - Nov 26, 2024</b></summary>
<ul>
  <li>Added matjectNEXT.</li>
  <li>Fixed writing on encrypted drives. (thanks to <a href=https://github.com/jcau8>@jcau8</a>)</li>
  <li>Added curl check.</li>
  <li>Renamed Partial Restore to Dynamic Restore.</li>
  <li>Improved Dynamic Restore speed.</li>
  <li>Fixed some typos.</li>
  <li>Other minor bug fixes.</li>
</ul>
</br>
</details>

<details><summary><b>v3.1.0 - Nov 18, 2024</b></summary>
<ul>
  <li>Bump version.</li>
  <li>Fix credit names <a href=https://github.com/faizul726/matject/pull/4>PR #4</a>.</li>
</ul>
</br>
</details>

<details><summary><b>v3.0.3 - Nov 16, 2024</b></summary>
<ul>
  <li>Added update checker (thanks to <a href=https://github.com/jcau8>@jcau8</a>).</li>
  <li>Moved variables to variables.bat.</li>
  <li>Fixed some typos.</li>
  <li>Delete backup date file after full restore.</li>
  <li>Added GitHub link in others.</li>
  <li>Changed <code>pushd</code> to <code>cd /d</code>.</li>
</ul>
</br>
</details>

<details><summary><b>v3.0.2 - Nov 15, 2024</b></summary>
<ul>
  <li>Fixed directory changing and unlockWindowsApps (thanks to <a href=https://github.com/Theffyxz>@Theffyxz</a>).</li>
  <li>Added update checker module as a placeholder.</li>
  <li>Added credits section in README.</li>
</ul>
</br>
</details>

<details><summary><b>v3.0.1 - Nov 13, 2024</b></summary>
<ul>
  <li>Fixed unlockWindowsApps not saving result.</li>
  <li>Updated "about" details.</li>
  <li>Semantic Versioning (something that I still don't understand properly).</li>
</ul>
</br>
</details>

<details>
  <summary><b>v3.0 - Nov 06, 2024</b></summary>
  <ul>
    <li>Fixed partial restore.</li>
    <li>Added <a href=https://github.com/mcbegamerxx954/material-updater>material-updater</a> support.</li>
    <li>Added help (but not helpful).</li>
    <li>Added settings.</li>
    <li>Added date for backup.</li>
    <li>Added the ability to open MCPACK automatically after injection.</li>
    <li>Added first run message.</li>
    <li>Made backup mandatory.</li>
    <li>Improved home screen.</li>
    <li>Only accept <code>*.material.bin</code> files.</li>
    <li>Removed <code>openMinecraftFolder.bat</code> and added it as a separate option.</li>
  </ul>
</br>
</details>

<details><summary><b>v2.5 - Oct 20, 2024</b></summary>
<ul>
  <li>Added colored texts.</li>
  <li>Removed settings.bat placeholder as it's not required before v3.0.</li>
</ul>
</br>
</details>

<details><summary><b>v2.0 - Unknown date</b></summary>
<ul>
  <li>Much more user-friendly than before.</li>
  <li>Dynamically finds Minecraft location.</li>
  <li>Skips questions if user meets requirements.</li>
  <li>Prompts to delete backup if it detects a different Minecraft version.</li>
  <li>Restores vanilla shaders <strong>(BETA)</strong>.</li>
  <li>Shows error if user declines UAC and asks again.</li>
  <li>Automatically opens MCPACK/MATERIALS folder for user to put files.</li>
  <li>Extracts materials from user-provided MCPACK/ZIP (still can't detect if it's an RD shader).</li>
  <li>Dynamically restores <strong>only</strong> modified bins from previous inject to ensure consistency among different shaders <strong>(BETA)</strong> (works only if user has made a backup before).</li>
  <li>Added <code>settings.bat</code> for tweaking options (WIP).</li>
  <li>Added <code>openMinecraftFolder.bat</code> to open the Minecraft folder.</li>
  <li>Simplified <code>WindowsApps</code> unlock procedure; now it unlocks instantly.</li>
</ul>
</br>
</details>

<details><summary><b>v1.0 - Unknown date</b></summary>
<ul><li>Initial release.</li></ul>
</details>
